/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class AbsoluteOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public AbsoluteOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int operand = this.instruction.getWordOp();
        this.instruction.setAddress(operand);
        String result = "($" + new HwWord((long)operand) + ") -> $" + new HwByte((long)this.instruction.getByteOp());
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        return this.instruction.getWordOp();
    }

    @Override
    public boolean isIndirect() {
        return false;
    }
}

